@extends('layouts.admin')

@section('title', 'Create News Article')

@section('content')
<div class="dashboard-container">
    <div class="dashboard-header">
        <div class="d-flex justify-content-between align-items-center">
            <h1>Create News Article</h1>
            <a href="{{ route('admin.news.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to News
            </a>
        </div>
        <p>Create a new news article</p>
    </div>

    <div class="dashboard-card dashboard-card-full">
        <div class="dashboard-card-header">
            <h3>News Article Details</h3>
        </div>
        <div class="dashboard-card-body">
            <form action="{{ route('admin.news.store') }}" method="POST" enctype="multipart/form-data">
                @csrf
                
                <div class="form-group">
                    <label for="title">Title</label>
                    <input type="text" name="title" id="title" class="form-control @error('title') has-error @enderror" value="{{ old('title') }}" required>
                    @error('title')
                        <div class="error-message">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="short_description">Short Description</label>
                    <textarea name="short_description" id="short_description" class="form-control @error('short_description') has-error @enderror" rows="3" required>{{ old('short_description') }}</textarea>
                    @error('short_description')
                        <div class="error-message">{{ $message }}</div>
                    @enderror
                    <div class="form-text">A brief description (max 500 characters) that will be shown in news listings</div>
                </div>

                <div class="form-group">
                    <label for="image">Featured Image</label>
                    <div class="file-upload-wrapper">
                        <input type="file" name="image" id="image" class="file-upload-input @error('image') has-error @enderror" accept="image/*">
                        <label for="image" class="file-upload-label">
                            <i class="fas fa-cloud-upload-alt file-upload-icon"></i>
                            <span>Choose an image file</span>
                        </label>
                        <div class="file-upload-preview" id="imagePreview"></div>
                    </div>
                    @error('image')
                        <div class="error-message">{{ $message }}</div>
                    @enderror
                    <div class="form-text">Recommended size: 1200 x 630 pixels</div>
                </div>

                <div class="form-group">
                    <label for="content">Content</label>
                    @component('components.bbcode-editor')
                        @slot('name', 'content')
                        @slot('content', old('content'))
                        @slot('placeholder', 'Enter the news article content here...')
                        @slot('height', '300px')
                    @endcomponent
                    @error('content')
                        <div class="error-message">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Create News Article
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
    <script>
        // Initialize BB Code Editor
        document.addEventListener('DOMContentLoaded', function() {
            if (document.querySelector('.bb-code-editor')) {
                new BBCodeEditor('.bb-code-editor');
            }
            
            // Image preview functionality
            const imageInput = document.getElementById('image');
            const imagePreview = document.getElementById('imagePreview');
            
            imageInput.addEventListener('change', function() {
                imagePreview.innerHTML = '';
                
                if (this.files && this.files[0]) {
                    const reader = new FileReader();
                    
                    reader.onload = function(e) {
                        const previewContainer = document.createElement('div');
                        previewContainer.className = 'new-file';
                        
                        const previewImage = document.createElement('img');
                        previewImage.className = 'file-preview';
                        previewImage.src = e.target.result;
                        
                        const fileName = document.createElement('span');
                        fileName.className = 'file-name';
                        fileName.textContent = imageInput.files[0].name;
                        
                        previewContainer.appendChild(previewImage);
                        previewContainer.appendChild(fileName);
                        imagePreview.appendChild(previewContainer);
                    }
                    
                    reader.readAsDataURL(this.files[0]);
                }
            });
        });
    </script>
@endpush